/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * \file    DM388_gpmc.h
 *
 * \brief   Defines the module register defines for GPMC
 *
 * This header file contains the Macros definitions and GPMC module
 *
 * \author  0043
 *
 * \version 01a,09aug,2010 Created.
 */

#ifndef _DM388_gpmc_H_
#define _DM388_gpmc_H_

#ifdef __cplusplus
 extern "C" {
#endif

/*
 *====================
 * Includes
 *====================
 */
#include "DM388_Soc.h"

/**
@addtogroup DM388 GPMC
@{
*/

/*
 *====================
 * Enumerations
 *====================
 */

/*
 *====================
 * Defines
 *====================
 */
#define GPMC_BASE             0x50000000
#define GPMC_REVISION         *( volatile UINT32* )( GPMC_BASE + 0x00 )
#define GPMC_SYSCONFIG        *( volatile UINT32* )( GPMC_BASE + 0x10 )
#define GPMC_SYSSTATUS        *( volatile UINT32* )( GPMC_BASE + 0x14 )
#define GPMC_IRQSTATUS        *( volatile UINT32* )( GPMC_BASE + 0x18 )
#define GPMC_IRQENABLE        *( volatile UINT32* )( GPMC_BASE + 0x1C )
#define GPMC_TIMEOUT_CONTROL  *( volatile UINT32* )( GPMC_BASE + 0x40 )
#define GPMC_ERR_ADDRESS      *( volatile UINT32* )( GPMC_BASE + 0x44 )
#define GPMC_ERR_TYPE         *( volatile UINT32* )( GPMC_BASE + 0x48 )
#define GPMC_CONFIG           *( volatile UINT32* )( GPMC_BASE + 0x50 )
#define GPMC_STATUS           *( volatile UINT32* )( GPMC_BASE + 0x54 )
#define GPMC_CONFIG1_0        *( volatile UINT32* )( GPMC_BASE + 0x60 )
#define GPMC_CONFIG2_0        *( volatile UINT32* )( GPMC_BASE + 0x64 )
#define GPMC_CONFIG3_0        *( volatile UINT32* )( GPMC_BASE + 0x68 )
#define GPMC_CONFIG4_0        *( volatile UINT32* )( GPMC_BASE + 0x6C )
#define GPMC_CONFIG5_0        *( volatile UINT32* )( GPMC_BASE + 0x70 )
#define GPMC_CONFIG6_0        *( volatile UINT32* )( GPMC_BASE + 0x74 )
#define GPMC_CONFIG7_0        *( volatile UINT32* )( GPMC_BASE + 0x78 )
#define GPMC_NAND_COMMAND_0   *( volatile UINT32* )( GPMC_BASE + 0x7C )
#define GPMC_NAND_ADDRESS_0   *( volatile UINT32* )( GPMC_BASE + 0x80 )
#define GPMC_NAND_DATA_0      *( volatile UINT32* )( GPMC_BASE + 0x84 )

#define GPMC_CONFIG1_1        *( volatile UINT32* )( GPMC_BASE + 0x90 )
#define GPMC_CONFIG2_1        *( volatile UINT32* )( GPMC_BASE + 0x94 )
#define GPMC_CONFIG3_1        *( volatile UINT32* )( GPMC_BASE + 0x98 )
#define GPMC_CONFIG4_1        *( volatile UINT32* )( GPMC_BASE + 0x9C )
#define GPMC_CONFIG5_1        *( volatile UINT32* )( GPMC_BASE + 0xA0 )
#define GPMC_CONFIG6_1        *( volatile UINT32* )( GPMC_BASE + 0xA4 )
#define GPMC_CONFIG7_1        *( volatile UINT32* )( GPMC_BASE + 0xA8 )
#define GPMC_NAND_COMMAND_1   *( volatile UINT32* )( GPMC_BASE + 0xAC )
#define GPMC_NAND_ADDRESS_1   *( volatile UINT32* )( GPMC_BASE + 0xB0 )
#define GPMC_NAND_DATA_1      *( volatile UINT32* )( GPMC_BASE + 0xB4 )

#define GPMC_CONFIG1_2        *( volatile UINT32* )( GPMC_BASE + 0xC0 )
#define GPMC_CONFIG2_2        *( volatile UINT32* )( GPMC_BASE + 0xC4 )
#define GPMC_CONFIG3_2        *( volatile UINT32* )( GPMC_BASE + 0xC8 )
#define GPMC_CONFIG4_2        *( volatile UINT32* )( GPMC_BASE + 0xCC )
#define GPMC_CONFIG5_2        *( volatile UINT32* )( GPMC_BASE + 0xD0 )
#define GPMC_CONFIG6_2        *( volatile UINT32* )( GPMC_BASE + 0xD4 )
#define GPMC_CONFIG7_2        *( volatile UINT32* )( GPMC_BASE + 0xD8 )
#define GPMC_NAND_COMMAND_2   *( volatile UINT32* )( GPMC_BASE + 0xDC )
#define GPMC_NAND_ADDRESS_2   *( volatile UINT32* )( GPMC_BASE + 0xE0 )
#define GPMC_NAND_DATA_2      *( volatile UINT32* )( GPMC_BASE + 0xE4 )

#define GPMC_CONFIG1_3        *( volatile UINT32* )( GPMC_BASE + 0xF0 )
#define GPMC_CONFIG2_3        *( volatile UINT32* )( GPMC_BASE + 0xF4 )
#define GPMC_CONFIG3_3        *( volatile UINT32* )( GPMC_BASE + 0xF8 )
#define GPMC_CONFIG4_3        *( volatile UINT32* )( GPMC_BASE + 0xFC )
#define GPMC_CONFIG5_3        *( volatile UINT32* )( GPMC_BASE + 0x100 )
#define GPMC_CONFIG6_3        *( volatile UINT32* )( GPMC_BASE + 0x104 )
#define GPMC_CONFIG7_3        *( volatile UINT32* )( GPMC_BASE + 0x108 )
#define GPMC_NAND_COMMAND_3   *( volatile UINT32* )( GPMC_BASE + 0x11C )
#define GPMC_NAND_ADDRESS_3   *( volatile UINT32* )( GPMC_BASE + 0x110 )
#define GPMC_NAND_DATA_3      *( volatile UINT32* )( GPMC_BASE + 0x114 )

#define GPMC_CONFIG1_3        *( volatile UINT32* )( GPMC_BASE + 0xF0 )
#define GPMC_CONFIG2_3        *( volatile UINT32* )( GPMC_BASE + 0xF4 )
#define GPMC_CONFIG3_3        *( volatile UINT32* )( GPMC_BASE + 0xF8 )
#define GPMC_CONFIG4_3        *( volatile UINT32* )( GPMC_BASE + 0xFC )
#define GPMC_CONFIG5_3        *( volatile UINT32* )( GPMC_BASE + 0x100 )
#define GPMC_CONFIG6_3        *( volatile UINT32* )( GPMC_BASE + 0x104 )
#define GPMC_CONFIG7_3        *( volatile UINT32* )( GPMC_BASE + 0x108 )
#define GPMC_NAND_COMMAND_3   *( volatile UINT32* )( GPMC_BASE + 0x11C )
#define GPMC_NAND_ADDRESS_3   *( volatile UINT32* )( GPMC_BASE + 0x110 )
#define GPMC_NAND_DATA_3      *( volatile UINT32* )( GPMC_BASE + 0x114 )

#define GPMC_CONFIG1_4        *( volatile UINT32* )( GPMC_BASE + 0x120 )
#define GPMC_CONFIG2_4        *( volatile UINT32* )( GPMC_BASE + 0x124 )
#define GPMC_CONFIG3_4        *( volatile UINT32* )( GPMC_BASE + 0x128 )
#define GPMC_CONFIG4_4        *( volatile UINT32* )( GPMC_BASE + 0x12C )
#define GPMC_CONFIG5_4        *( volatile UINT32* )( GPMC_BASE + 0x130 )
#define GPMC_CONFIG6_4        *( volatile UINT32* )( GPMC_BASE + 0x134 )
#define GPMC_CONFIG7_4        *( volatile UINT32* )( GPMC_BASE + 0x138 )
#define GPMC_NAND_COMMAND_4   *( volatile UINT32* )( GPMC_BASE + 0x13C )
#define GPMC_NAND_ADDRESS_4   *( volatile UINT32* )( GPMC_BASE + 0x140 )
#define GPMC_NAND_DATA_4      *( volatile UINT32* )( GPMC_BASE + 0x144 )

#define GPMC_CONFIG1_5        *( volatile UINT32* )( GPMC_BASE + 0x150 )
#define GPMC_CONFIG2_5        *( volatile UINT32* )( GPMC_BASE + 0x154 )
#define GPMC_CONFIG3_5        *( volatile UINT32* )( GPMC_BASE + 0x158 )
#define GPMC_CONFIG4_5        *( volatile UINT32* )( GPMC_BASE + 0x15C )
#define GPMC_CONFIG5_5        *( volatile UINT32* )( GPMC_BASE + 0x160 )
#define GPMC_CONFIG6_5        *( volatile UINT32* )( GPMC_BASE + 0x164 )
#define GPMC_CONFIG7_5        *( volatile UINT32* )( GPMC_BASE + 0x168 )
#define GPMC_NAND_COMMAND_5   *( volatile UINT32* )( GPMC_BASE + 0x16C )
#define GPMC_NAND_ADDRESS_5   *( volatile UINT32* )( GPMC_BASE + 0x170 )
#define GPMC_NAND_DATA_5      *( volatile UINT32* )( GPMC_BASE + 0x174 )

#define GPMC_CONFIG1_6        *( volatile UINT32* )( GPMC_BASE + 0x180 )
#define GPMC_CONFIG2_6        *( volatile UINT32* )( GPMC_BASE + 0x184 )
#define GPMC_CONFIG3_6        *( volatile UINT32* )( GPMC_BASE + 0x188 )
#define GPMC_CONFIG4_6        *( volatile UINT32* )( GPMC_BASE + 0x18C )
#define GPMC_CONFIG5_6        *( volatile UINT32* )( GPMC_BASE + 0x190 )
#define GPMC_CONFIG6_6        *( volatile UINT32* )( GPMC_BASE + 0x194 )
#define GPMC_CONFIG7_6        *( volatile UINT32* )( GPMC_BASE + 0x198 )
#define GPMC_NAND_COMMAND_6   *( volatile UINT32* )( GPMC_BASE + 0x19C )
#define GPMC_NAND_ADDRESS_6   *( volatile UINT32* )( GPMC_BASE + 0x1A0 )
#define GPMC_NAND_DATA_6      *( volatile UINT32* )( GPMC_BASE + 0x1A4 )

#define GPMC_CONFIG1_7        *( volatile UINT32* )( GPMC_BASE + 0x1B0 )
#define GPMC_CONFIG2_7        *( volatile UINT32* )( GPMC_BASE + 0x1B4 )
#define GPMC_CONFIG3_7        *( volatile UINT32* )( GPMC_BASE + 0x1B8 )
#define GPMC_CONFIG4_7        *( volatile UINT32* )( GPMC_BASE + 0x1BC )
#define GPMC_CONFIG5_7        *( volatile UINT32* )( GPMC_BASE + 0x1C0 )
#define GPMC_CONFIG6_7        *( volatile UINT32* )( GPMC_BASE + 0x1C4 )
#define GPMC_CONFIG7_7        *( volatile UINT32* )( GPMC_BASE + 0x1C8 )
#define GPMC_NAND_COMMAND_7   *( volatile UINT32* )( GPMC_BASE + 0x1CC )
#define GPMC_NAND_ADDRESS_7   *( volatile UINT32* )( GPMC_BASE + 0x1D0 )
#define GPMC_NAND_DATA_7      *( volatile UINT32* )( GPMC_BASE + 0x1D4 )

#define GPMC_PREFETCH_CONFIG1 *( volatile UINT32* )( GPMC_BASE + 0x1E0 )
#define GPMC_PREFETCH_CONFIG2 *( volatile UINT32* )( GPMC_BASE + 0x1E4 )
#define GPMC_PREFETCH_CONTROL *( volatile UINT32* )( GPMC_BASE + 0x1EC )
#define GPMC_PREFETCH_STATUS  *( volatile UINT32* )( GPMC_BASE + 0x1F0 )
#define GPMC_ECC_CONFIG       *( volatile UINT32* )( GPMC_BASE + 0x1F4 )
#define GPMC_ECC_CONTROL      *( volatile UINT32* )( GPMC_BASE + 0x1F8 )
#define GPMC_ECC_SIZE_CONFIG  *( volatile UINT32* )( GPMC_BASE + 0x1FC )
#define GPMC_ECC1_RESULT      *( volatile UINT32* )( GPMC_BASE + 0x200 )
#define GPMC_ECC2_RESULT      *( volatile UINT32* )( GPMC_BASE + 0x204 )
#define GPMC_ECC3_RESULT      *( volatile UINT32* )( GPMC_BASE + 0x208 )
#define GPMC_ECC4_RESULT      *( volatile UINT32* )( GPMC_BASE + 0x20C )
#define GPMC_ECC5_RESULT      *( volatile UINT32* )( GPMC_BASE + 0x210 )
#define GPMC_ECC6_RESULT      *( volatile UINT32* )( GPMC_BASE + 0x214 )
#define GPMC_ECC7_RESULT      *( volatile UINT32* )( GPMC_BASE + 0x218 )
#define GPMC_ECC8_RESULT      *( volatile UINT32* )( GPMC_BASE + 0x21C )
#define GPMC_ECC9_RESULT      *( volatile UINT32* )( GPMC_BASE + 0x220 )
#define GPMC_TESTMODE_CTRL    *( volatile UINT32* )( GPMC_BASE + 0x230 )

/* @} */   /* End of GPMC */

#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif  /* End of _DM388_gpmc_H_ */
